/*
 * Type definitions for the mshv host interface.
 *
 * Copyright Microsoft, Corp. 2025
 *
 * SPDX-License-Identifier: GPL-2.0-or-later
 */

#ifndef HW_HYPERV_HVHDK_MINI_H
#define HW_HYPERV_HVHDK_MINI_H

#define HVHVK_MINI_VERSION (25294)

/* Each generic set contains 64 elements */
#define HV_GENERIC_SET_SHIFT (6)
#define HV_GENERIC_SET_MASK  (63)

enum hv_generic_set_format {
    HV_GENERIC_SET_SPARSE_4K,
    HV_GENERIC_SET_ALL,
};

enum hv_partition_property_code {
    /* Privilege properties */
    HV_PARTITION_PROPERTY_PRIVILEGE_FLAGS         = 0x00010000,
    HV_PARTITION_PROPERTY_SYNTHETIC_PROC_FEATURES = 0x00010001,

    /* Scheduling properties */
    HV_PARTITION_PROPERTY_SUSPEND      = 0x00020000,
    HV_PARTITION_PROPERTY_CPU_RESERVE  = 0x00020001,
    HV_PARTITION_PROPERTY_CPU_CAP      = 0x00020002,
    HV_PARTITION_PROPERTY_CPU_WEIGHT   = 0x00020003,
    HV_PARTITION_PROPERTY_CPU_GROUP_ID = 0x00020004,

    /* Time properties */
    HV_PARTITION_PROPERTY_TIME_FREEZE    = 0x00030003,
    HV_PARTITION_PROPERTY_REFERENCE_TIME = 0x00030005,

    /* Debugging properties */
    HV_PARTITION_PROPERTY_DEBUG_CHANNEL_ID = 0x00040000,

    /* Resource properties */
    HV_PARTITION_PROPERTY_VIRTUAL_TLB_PAGE_COUNT                 = 0x00050000,
    HV_PARTITION_PROPERTY_VSM_CONFIG                             = 0x00050001,
    HV_PARTITION_PROPERTY_ZERO_MEMORY_ON_RESET                   = 0x00050002,
    HV_PARTITION_PROPERTY_PROCESSORS_PER_SOCKET                  = 0x00050003,
    HV_PARTITION_PROPERTY_NESTED_TLB_SIZE                        = 0x00050004,
    HV_PARTITION_PROPERTY_GPA_PAGE_ACCESS_TRACKING               = 0x00050005,
    HV_PARTITION_PROPERTY_VSM_PERMISSIONS_DIRTY_SINCE_LAST_QUERY = 0x00050006,
    HV_PARTITION_PROPERTY_SGX_LAUNCH_CONTROL_CONFIG              = 0x00050007,
    HV_PARTITION_PROPERTY_DEFAULT_SGX_LAUNCH_CONTROL0            = 0x00050008,
    HV_PARTITION_PROPERTY_DEFAULT_SGX_LAUNCH_CONTROL1            = 0x00050009,
    HV_PARTITION_PROPERTY_DEFAULT_SGX_LAUNCH_CONTROL2            = 0x0005000a,
    HV_PARTITION_PROPERTY_DEFAULT_SGX_LAUNCH_CONTROL3            = 0x0005000b,
    HV_PARTITION_PROPERTY_ISOLATION_STATE                        = 0x0005000c,
    HV_PARTITION_PROPERTY_ISOLATION_CONTROL                      = 0x0005000d,
    HV_PARTITION_PROPERTY_ALLOCATION_ID                          = 0x0005000e,
    HV_PARTITION_PROPERTY_MONITORING_ID                          = 0x0005000f,
    HV_PARTITION_PROPERTY_IMPLEMENTED_PHYSICAL_ADDRESS_BITS      = 0x00050010,
    HV_PARTITION_PROPERTY_NON_ARCHITECTURAL_CORE_SHARING         = 0x00050011,
    HV_PARTITION_PROPERTY_HYPERCALL_DOORBELL_PAGE                = 0x00050012,
    HV_PARTITION_PROPERTY_ISOLATION_POLICY                       = 0x00050014,
    HV_PARTITION_PROPERTY_UNIMPLEMENTED_MSR_ACTION               = 0x00050017,
    HV_PARTITION_PROPERTY_SEV_VMGEXIT_OFFLOADS                   = 0x00050022,

    /* Compatibility properties */
    HV_PARTITION_PROPERTY_PROCESSOR_VENDOR              = 0x00060000,
    HV_PARTITION_PROPERTY_PROCESSOR_FEATURES_DEPRECATED = 0x00060001,
    HV_PARTITION_PROPERTY_PROCESSOR_XSAVE_FEATURES      = 0x00060002,
    HV_PARTITION_PROPERTY_PROCESSOR_CL_FLUSH_SIZE       = 0x00060003,
    HV_PARTITION_PROPERTY_ENLIGHTENMENT_MODIFICATIONS   = 0x00060004,
    HV_PARTITION_PROPERTY_COMPATIBILITY_VERSION         = 0x00060005,
    HV_PARTITION_PROPERTY_PHYSICAL_ADDRESS_WIDTH        = 0x00060006,
    HV_PARTITION_PROPERTY_XSAVE_STATES                  = 0x00060007,
    HV_PARTITION_PROPERTY_MAX_XSAVE_DATA_SIZE           = 0x00060008,
    HV_PARTITION_PROPERTY_PROCESSOR_CLOCK_FREQUENCY     = 0x00060009,
    HV_PARTITION_PROPERTY_PROCESSOR_FEATURES0           = 0x0006000a,
    HV_PARTITION_PROPERTY_PROCESSOR_FEATURES1           = 0x0006000b,

    /* Guest software properties */
    HV_PARTITION_PROPERTY_GUEST_OS_ID = 0x00070000,

    /* Nested virtualization properties */
    HV_PARTITION_PROPERTY_PROCESSOR_VIRTUALIZATION_FEATURES = 0x00080000,
};

/* HV Map GPA (Guest Physical Address) Flags */
#define HV_MAP_GPA_PERMISSIONS_NONE        0x0
#define HV_MAP_GPA_READABLE                0x1
#define HV_MAP_GPA_WRITABLE                0x2
#define HV_MAP_GPA_KERNEL_EXECUTABLE       0x4
#define HV_MAP_GPA_USER_EXECUTABLE         0x8
#define HV_MAP_GPA_EXECUTABLE              0xC
#define HV_MAP_GPA_PERMISSIONS_MASK        0xF
#define HV_MAP_GPA_ADJUSTABLE           0x8000
#define HV_MAP_GPA_NO_ACCESS           0x10000
#define HV_MAP_GPA_NOT_CACHED         0x200000
#define HV_MAP_GPA_LARGE_PAGE       0x80000000

#define HV_PFN_RNG_PAGEBITS 24  /* HV_SPA_PAGE_RANGE_ADDITIONAL_PAGES_BITS */

#endif /* HW_HYPERV_HVHDK_MINI_H */
