# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.migrationassessment.aio import MigrationAssessmentMgmtClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestMigrationAssessmentMgmtSqlAssessmentV2OperationsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(MigrationAssessmentMgmtClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sql_assessment_v2_operations_list_by_group(self, resource_group):
        response = self.client.sql_assessment_v2_operations.list_by_group(
            resource_group_name=resource_group.name,
            project_name="str",
            group_name="str",
            api_version="2023-03-15",
        )
        result = [r async for r in response]
        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sql_assessment_v2_operations_get(self, resource_group):
        response = await self.client.sql_assessment_v2_operations.get(
            resource_group_name=resource_group.name,
            project_name="str",
            group_name="str",
            assessment_name="str",
            api_version="2023-03-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sql_assessment_v2_operations_begin_create(self, resource_group):
        response = await (
            await self.client.sql_assessment_v2_operations.begin_create(
                resource_group_name=resource_group.name,
                project_name="str",
                group_name="str",
                assessment_name="str",
                resource={
                    "id": "str",
                    "name": "str",
                    "properties": {
                        "assessmentType": "str",
                        "asyncCommitModeIntent": "str",
                        "azureLocation": "str",
                        "azureOfferCode": "str",
                        "azureOfferCodeForVm": "str",
                        "azureSecurityOfferingType": "str",
                        "azureSqlDatabaseSettings": {
                            "azureSqlComputeTier": "str",
                            "azureSqlDataBaseType": "str",
                            "azureSqlPurchaseModel": "str",
                            "azureSqlServiceTier": "str",
                        },
                        "azureSqlManagedInstanceSettings": {
                            "azureSqlInstanceType": "str",
                            "azureSqlServiceTier": "str",
                        },
                        "azureSqlVmSettings": {"instanceSeries": ["str"]},
                        "confidenceRatingInPercentage": 0.0,
                        "createdTimestamp": "2020-02-20 00:00:00",
                        "currency": "str",
                        "disasterRecoveryLocation": "str",
                        "discountPercentage": 0.0,
                        "eaSubscriptionId": "str",
                        "enableHadrAssessment": bool,
                        "entityUptime": {"daysPerMonth": 0, "hoursPerDay": 0},
                        "environmentType": "str",
                        "groupType": "str",
                        "isInternetAccessAvailable": bool,
                        "multiSubnetIntent": "str",
                        "optimizationLogic": "str",
                        "osLicense": "str",
                        "percentile": "str",
                        "perfDataEndTime": "2020-02-20 00:00:00",
                        "perfDataStartTime": "2020-02-20 00:00:00",
                        "pricesTimestamp": "2020-02-20 00:00:00",
                        "provisioningState": "str",
                        "reservedInstance": "str",
                        "reservedInstanceForVm": "str",
                        "scalingFactor": 0.0,
                        "schemaVersion": "str",
                        "sizingCriterion": "str",
                        "sqlServerLicense": "str",
                        "stage": "str",
                        "status": "str",
                        "timeRange": "str",
                        "updatedTimestamp": "2020-02-20 00:00:00",
                    },
                    "systemData": {
                        "createdAt": "2020-02-20 00:00:00",
                        "createdBy": "str",
                        "createdByType": "str",
                        "lastModifiedAt": "2020-02-20 00:00:00",
                        "lastModifiedBy": "str",
                        "lastModifiedByType": "str",
                    },
                    "type": "str",
                },
                api_version="2023-03-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sql_assessment_v2_operations_delete(self, resource_group):
        response = await self.client.sql_assessment_v2_operations.delete(
            resource_group_name=resource_group.name,
            project_name="str",
            group_name="str",
            assessment_name="str",
            api_version="2023-03-15",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_sql_assessment_v2_operations_begin_download_url(self, resource_group):
        response = await (
            await self.client.sql_assessment_v2_operations.begin_download_url(
                resource_group_name=resource_group.name,
                project_name="str",
                group_name="str",
                assessment_name="str",
                body={},
                api_version="2023-03-15",
            )
        ).result()  # call '.result()' to poll until service return final result

        # please add some check logic here by yourself
        # ...
