# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from enum import Enum
from azure.core import CaseInsensitiveEnumMeta


class AliasPathAttributes(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The attributes of the token that the alias path is referring to."""

    NONE = "None"
    """The token that the alias path is referring to has no attributes."""
    MODIFIABLE = "Modifiable"
    """The token that the alias path is referring to is modifiable by policies with 'modify' effect."""


class AliasPathTokenType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the token that the alias path is referring to."""

    NOT_SPECIFIED = "NotSpecified"
    """The token type is not specified."""
    ANY = "Any"
    """The token type can be anything."""
    STRING = "String"
    """The token type is string."""
    OBJECT = "Object"
    """The token type is object."""
    ARRAY = "Array"
    """The token type is array."""
    INTEGER = "Integer"
    """The token type is integer."""
    NUMBER = "Number"
    """The token type is number."""
    BOOLEAN = "Boolean"
    """The token type is boolean."""


class AliasPatternType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of alias pattern."""

    NOT_SPECIFIED = "NotSpecified"
    """NotSpecified is not allowed."""
    EXTRACT = "Extract"
    """Extract is the only allowed value."""


class AliasType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The type of the alias."""

    NOT_SPECIFIED = "NotSpecified"
    """Alias type is unknown (same as not providing alias type)."""
    PLAIN_TEXT = "PlainText"
    """Alias value is not secret."""
    MASK = "Mask"
    """Alias value is secret."""


class ExportTemplateOutputFormat(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The output format for the exported resources."""

    JSON = "Json"
    BICEP = "Bicep"


class ExtendedLocationType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The extended location type."""

    EDGE_ZONE = "EdgeZone"


class ProviderAuthorizationConsentState(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The provider authorization consent state."""

    NOT_SPECIFIED = "NotSpecified"
    REQUIRED = "Required"
    NOT_REQUIRED = "NotRequired"
    CONSENTED = "Consented"


class ResourceIdentityType(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The identity type."""

    SYSTEM_ASSIGNED = "SystemAssigned"
    USER_ASSIGNED = "UserAssigned"
    SYSTEM_ASSIGNED_USER_ASSIGNED = "SystemAssigned, UserAssigned"
    NONE = "None"


class TagsPatchOperation(str, Enum, metaclass=CaseInsensitiveEnumMeta):
    """The operation type for the patch API."""

    REPLACE = "Replace"
    """The 'replace' option replaces the entire set of existing tags with a new set."""
    MERGE = "Merge"
    """The 'merge' option allows adding tags with new names and updating the values of tags with
    existing names."""
    DELETE = "Delete"
    """The 'delete' option allows selectively deleting tags based on given names or name/value pairs."""
