; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=m68k-linux -verify-machineinstrs | FileCheck %s

declare {i32, i1} @llvm.sadd.with.overflow.i32(i32, i32)
declare {i32, i1} @llvm.uadd.with.overflow.i32(i32, i32)

define fastcc i32 @test5(i32 %v1, i32 %v2, ptr %X) nounwind {
; CHECK-LABEL: test5:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add.l %d1, %d0
; CHECK-NEXT:    bvs .LBB0_2
; CHECK-NEXT:  ; %bb.1: ; %normal
; CHECK-NEXT:    move.l #0, (%a0)
; CHECK-NEXT:  .LBB0_2: ; %overflow
; CHECK-NEXT:    rts
entry:
  %t = call {i32, i1} @llvm.sadd.with.overflow.i32(i32 %v1, i32 %v2)
  %sum = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  br i1 %obit, label %overflow, label %normal

normal:
  store i32 0, ptr %X
  br label %overflow

overflow:
  ret i32 %sum
}

define fastcc i1 @test6(i32 %v1, i32 %v2, ptr %X) nounwind {
; CHECK-LABEL: test6:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add.l %d1, %d0
; CHECK-NEXT:    bcs .LBB1_2
; CHECK-NEXT:  ; %bb.1: ; %normal
; CHECK-NEXT:    move.l #0, (%a0)
; CHECK-NEXT:  .LBB1_2: ; %carry
; CHECK-NEXT:    moveq #0, %d0
; CHECK-NEXT:    rts
entry:
  %t = call {i32, i1} @llvm.uadd.with.overflow.i32(i32 %v1, i32 %v2)
  %sum = extractvalue {i32, i1} %t, 0
  %obit = extractvalue {i32, i1} %t, 1
  br i1 %obit, label %carry, label %normal

normal:
  store i32 0, ptr %X
  br label %carry

carry:
    ret i1 false
}

define {i32, i1} @test7(i32 %v1, i32 %v2) nounwind {
; CHECK-LABEL: test7:
; CHECK:       ; %bb.0:
; CHECK-NEXT:    move.l (4,%sp), %d0
; CHECK-NEXT:    add.l (8,%sp), %d0
; CHECK-NEXT:    scs %d1
; CHECK-NEXT:    rts
  %t = call {i32, i1} @llvm.uadd.with.overflow.i32(i32 %v1, i32 %v2)
  ret {i32, i1} %t
}

define fastcc i1 @test10(i32 %x) nounwind {
; CHECK-LABEL: test10:
; CHECK:       ; %bb.0: ; %entry
; CHECK-NEXT:    add.l #1, %d0
; CHECK-NEXT:    svs %d0
; CHECK-NEXT:    rts
entry:
  %t = call {i32, i1} @llvm.sadd.with.overflow.i32(i32 %x, i32 1)
  %obit = extractvalue {i32, i1} %t, 1
  ret i1 %obit
}
